<?php

    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST', 'OPTIONS');
    header("Access-Control-Allow-Credentials: true");
    header("Access-Control-Max-Age: 86400");
    header("Access-Control-Allow-Headers: X-Requested-With");

    include "./connify.php";  // Your database connection file
    $userHash      = (mysqli_real_escape_string($con,$_GET['token']));
    

    $stmt = $con -> prepare('SELECT  id,userType,status  FROM users  WHERE  token = ?'); 
    $stmt -> bind_param('s',$userHash); 
    $stmt -> execute(); 
    $stmt -> store_result(); 
    $stmt -> bind_result($i,$userType,$status);
    $count  = $stmt->num_rows;
    $stmt -> fetch();
    
    if($count === 0){
        $wholesale = 'retail';
    }else{
        if($userType === 'wholesale'){
            $wholesale = 'wholesale';
        }else{
            $wholesale = 'retail';
        }
    }
    
    
    // Pagination logic
    $limit = 1;  // Number of images to load per request
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $offset = ($page - 1) * $limit;
    
    $imagePath = 'https://app.buzeefoods.co.uk/api/uploads/';
    
    // Query to fetch products from the database
    $sql = "SELECT * FROM product LIMIT $limit OFFSET $offset";
    $result = $con->query($sql);
    
    // Check if any products are found
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            
            // Fetch data for each product
            $product_id = $row['product_id'];
            $product_name = htmlspecialchars($row['product']);  // Make sure to escape special characters
            $product_img = $row['img'];  // Image path
            $product_price = $row['price'];  // Product price
            $product_qty = $row['qty'];  // Product quantity
            $product_type = $row['product_type'];
            $weightType = $row['weightType'];
            $product_discount = $row['fake_price'];

            


            // Output the HTML for each product
            echo '
                    <div class="col md-28 mb-6" style="margin-bottom: 20px;">
                        <div class="product__items border rounded-lg shadow-lg overflow-hidden bg-white">
                            <div class="product__items--thumbnail relative">
                                <a class="product__items--link block overflow-hidden" data-product-id="$product_id">
                                    <img id="open$product_id" class="product__items--img product__primary--img w-full transition-transform duration-300 ease-in-out transform hover:scale-105" 
                                        src="'.$imagePath.$product_id.'_1.webp" alt="'.$product_name.'">
                                    <img id="open'.$product_id.'" class="product__items--img product__secondary--img hidden" 
                                        src="'.$imagePath . $product_id.'_2.webp" alt="">
                                </a>
                                <div class="product__badge">';
                                if ($product_type === "rp") {
                                   echo '<span class="product__badge--items sale">Sale</span>';
                                } else {
                                   echo '<span class="product__badge--items sale" style="background-color:red">Wholesale</span>';
                                }
                echo '</div>
                        <ul class="product__items--action">
                            <li class="product__items--action__list"  id="fav'.$product_id.'">
                                <a class="checkFavorite product__items--action__btn" href="javascript:void(0);"   >
                                    <svg class="product__items--action__btn--svg" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                        <path d="M352.92 80C288 80 256 144 256 144s-32-64-96.92-64c-52.76 0-94.54 44.14-95.08 96.81-1.1 109.33 86.73 187.08 183 252.42a16 16 0 0018 0c96.26-65.34 184.09-143.09 183-252.42-.54-52.67-42.32-96.81-95.08-96.81z" 
                                        fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32"/>
                                    </svg>
                                    <span class="visually-hidden">Wishlist</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="product__items--content text-center p-4">
                        <h3 class="text-lg font-semibold" style="font-size:16px">
                            <a id="open$product.product_id">' .$product_name .'</a>
                        </h3>';

                if ($product_type === 'rp') {
                    if ($weightType === 'wp') {
                        echo '<div class="product__items--price text-gray-700 mt-2">
                                <span class="text-xl font-bold text-green-600 current__price" style="font-size:20px">£ ' . $product_price . '</span>
                                <span class="text-sm text-gray-400 line-through ml-2" style="font-size:20px;color:green"> - £ ' . $product_discount . '</span>
                              </div>
                              <a class="btn deals__banner--content__btn" id="open' . $product_id . '" style="background-color:gray"> Option </a>';

                    } else {
                        echo '<div class="product__items--price text-gray-700 mt-2">
                                <span class="text-xl font-bold text-green-600 current__price" style="font-size:20px"> £'.$product_price.'</span>
                                <span class="text-sm text-gray-400 line-through ml-2 old__price" style="font-size:20px"> - £ '.$product_discount.'</span>
                            </div>
                            <a class="btn deals__banner--content__btn" id="cart'.$product_id.'"> Add to Cart </a>';
                    }
                } else if ($product_type === 'wsp') {
                    if ($userType === 'wholesale') {
                        if ($weightType === 'wp') {
                            if ($userType === null) {
                                echo '<div class="product__items--price text-gray-700 mt-2">
                                        <span class="text-xl font-bold text-green-600 current__price" style="font-size:20px">'.$product_price.'</span>
                                        <span class="text-sm text-gray-400 line-through ml-2 old__price" style="font-size:20px">'.$product_discount.'</span>
                                    </div>
                                    <a class="btn deals__banner--content__btn"  id="lock" >
                                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e8eaed">
                                            <path d="M240-80q-33 0-56.5-23.5T160-160v-400q0-33 23.5-56.5T240-640h40v-80q0-83 58.5-141.5T480-920q83 0 141.5 58.5T680-720v80h40q33 0 56.5 23.5T800-560v400q0 33-23.5 56.5T720-80H240Zm240-200q33 0 56.5-23.5T560-360q0-33-23.5-56.5T480-440q-33 0-56.5 23.5T400-360q0 33 23.5 56.5T480-280ZM360-640h240v-80q0-50-35-85t-85-35q-50 0-85 35t-35 85v80Z"/>
                                        </svg>
                                    </a>';
                            } else {
                                echo '<div class="product__items--price text-gray-700 mt-2">
                                        <span class="text-xl font-bold text-green-600 current__price" style="font-size:20px">'.$product_price.'</span>
                                        <span class="text-sm text-gray-400 line-through ml-2 old__price" style="font-size:20px">'.$product_discount.'</span>
                                    </div>
                                    <a class="btn deals__banner--content__btn" id="open'.$product_id.'"> Option </a>';
                            }
                        } else {

                            if ($userType === null) {
                                echo '<div class="product__items--price text-gray-700 mt-2">
                                        <span class="text-xl font-bold text-green-600 current__price" style="font-size:20px">'.$product_price.'</span>
                                        <span class="text-sm text-gray-400 line-through ml-2 old__price" style="font-size:20px">'.$product_discount.'</span>
                                    </div>
                                    <a class="btn deals__banner--content__btn" id="lock" >
                                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e8eaed">
                                            <path d="M240-80q-33 0-56.5-23.5T160-160v-400q0-33 23.5-56.5T240-640h40v-80q0-83 58.5-141.5T480-920q83 0 141.5 58.5T680-720v80h40q33 0 56.5 23.5T800-560v400q0 33-23.5 56.5T720-80H240Zm240-200q33 0 56.5-23.5T560-360q0-33-23.5-56.5T480-440q-33 0-56.5 23.5T400-360q0 33 23.5 56.5T480-280ZM360-640h240v-80q0-50-35-85t-85-35q-50 0-85 35t-35 85v80Z"/>
                                        </svg>
                                    </a>';
                            } else {
                                echo '<div class="product__items--price text-gray-700 mt-2">
                                        <span class="text-xl font-bold text-green-600 current__price" style="font-size:20px">'.$product_price.'</span>
                                        <span class="text-sm text-gray-400 line-through ml-2 old__price" style="font-size:20px">'.$product_discount.'</span>
                                    </div>
                                    <a class="btn deals__banner--content__btn" id="cart'.$product_id.'"> Add to Cart </a>';
                            }
                            
                        }
                    } else {
                        echo '<div class="product__items--price text-gray-700 mt-2">
                                <span class="text-xl font-bold text-green-600 current__price" style="font-size:20px">'.$product_price.'</span>
                                <span class="text-sm text-gray-400 line-through ml-2 old__price" style="font-size:20px">'.$product_discount.'</span>
                            </div>
                            <a class="btn deals__banner--content__btn" href="#" style="background-color:red" id="lock">
                                <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#e8eaed">
                                    <path d="M240-80q-33 0-56.5-23.5T160-160v-400q0-33 23.5-56.5T240-640h40v-80q0-83 58.5-141.5T480-920q83 0 141.5 58.5T680-720v80h40q33 0 56.5 23.5T800-560v400q0 33-23.5 56.5T720-80H240Zm240-200q33 0 56.5-23.5T560-360q0-33-23.5-56.5T480-440q-33 0-56.5 23.5T400-360q0 33 23.5 56.5T480-280ZM360-640h240v-80q0-50-35-85t-85-35q-50 0-85 35t-35 85v80Z"/>
                                </svg>
                            </a>';
                    }
                }
                
        }
    
    }
     

?>
