<?php

    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
    header("Access-Control-Allow-Credentials: true");
    header("Access-Control-Max-Age: 86400");
    header("Access-Control-Allow-Headers: X-Requested-With, Content-Type");
    
    include "./connify.php";
    
    $product         = (mysqli_real_escape_string($con,$_POST['product'])); 
    $status ='active';
     
    $stmt = $con->prepare("SELECT name, comment, date FROM reviews WHERE product_id = ? AND status = ?");
    $stmt->bind_param("ss", $product,$status);
    $stmt->execute();
    $stmt->bind_result($name, $comment,$date);
    
    // Fetch data into an array
    $categories = [];
    while ($stmt->fetch()) {
        $categories[] = ["name" => $name, "comment" => $comment, 'date'=>$date];
    }
    
    // Check if the array is empty and respond accordingly
    header('Content-Type: application/json');
    if (empty($categories)) {
        // Return a JSON response for no records
        echo json_encode(["message" => "Be the first to review the product", 'status'=> 'false']);
    } else {
        // Return the fetched data
        echo json_encode($categories);
    }
    
    // Close connections
    $stmt->close();
    $con->close();

 

?>
