<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 86400");
header("Access-Control-Allow-Headers: X-Requested-With, Content-Type");
header('Content-Type: application/json'); // Set response content type

// Include the database connection
include "./connify.php";

try {
    // Prepare the SQL statement
    $stmt = $con->prepare("SELECT id,title, amount FROM shippment");
    if (!$stmt) {
        throw new Exception("Failed to prepare SQL statement: " . $con->error);
    }

    // Execute the query
    if (!$stmt->execute()) {
        throw new Exception("Failed to execute SQL statement: " . $stmt->error);
    }

    // Bind the result variables
    $stmt->bind_result($id,$title, $amount);

    // Fetch data into an array
    $categories = [];
    while ($stmt->fetch()) {
        $categories[] = ['id' => $id,"title" => $title, "total" => $amount];
    }

    // Return data as JSON
    echo json_encode($categories);

} catch (Exception $e) {
    // Handle exceptions
    http_response_code(500);
    echo json_encode(["error" => $e->getMessage()]);
} finally {
    // Close connections
    if (isset($stmt)) {
        $stmt->close();
    }
    if (isset($con)) {
        $con->close();
    }
}

?>