<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 86400");
header("Access-Control-Allow-Headers: X-Requested-With, Content-Type");

// Include the database connection
include "./connify.php";

$product         = (mysqli_real_escape_string($con,$_POST['product']));  

try {
    // Prepare the SQL statement
    $stmt = $con->prepare("SELECT method_name, image FROM images WHERE method_name = ?  ORDER BY RAND() LIMIT 10 ");
    $stmt->bind_param('s', $product); // Bind the $PROD parameter as a string
    $stmt->execute();
    $stmt->bind_result($method_name, $image);
    
    // Fetch data into an array
    $categories = [];
    while ($stmt->fetch()) {
        $categories[] = ["method_name" => $method_name, "image" => $image];
    }
    
    // Return data as JSON
    header('Content-Type: application/json');
    echo json_encode($categories);

} catch (Exception $e) {
    // Handle exceptions
    http_response_code(500);
    echo json_encode(["error" => "An error occurred while processing the request."]);
}

// Close connections
$stmt->close();
$con->close();

?>
