<?php

    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST', 'OPTIONS');
    header("Access-Control-Allow-Credentials: true");
    header("Access-Control-Max-Age: 86400");
    header("Access-Control-Allow-Headers: X-Requested-With");
    // header("Access-Control-Allow-Headers", "Access-Control-Allow-Headers, Origin,Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers");


    include "./connify.php";
    // include "./clean.php";
     
    $userHash      = (mysqli_real_escape_string($con,$_POST['userHash']));  
    
        
    
    $stmt = $con -> prepare('SELECT  id,userType,status  FROM users  WHERE  token = ?'); 
    $stmt -> bind_param('s',$userHash); 
    $stmt -> execute(); 
    $stmt -> store_result(); 
    $stmt -> bind_result($i,$userType,$status);
    $count  = $stmt->num_rows;
    $stmt -> fetch();
    
    if($count === 0){
        $wholesale = 'retail';
    }else{
        if($userType === 'wholesale'){
            $wholesale = 'wholesale';
        }else{
            
            $wholesale = 'retail';
        }
    }
    
    
    
    $stmt = $con->prepare("SELECT product, product_id, category_id, weight, img, price, discount, qty , product_type, weightType FROM product  ORDER BY id LIMIT 10"); // Randomly order the rows RAND()
    $stmt->execute();
    $stmt->bind_result($product, $product_id, $category_id, $weight, $img, $price, $discount, $qty, $product_type, $weightType);
    
    // Fetch data into an array
    $categories = [];
    while ($stmt->fetch()) {
        if (empty($price)) {
            $price = 0;
        }
        $categories[] = [
            "product" => $product,
            "product_id" => $product_id,
            "category_id" => $category_id,
            "weight" => $weight,
            "img" => $img,
            "price" => '£' . $price,
            "discount" => $discount,
            "qty" => $qty,
            'product_type'=> $product_type,
            "weightType"=> $weightType
        ];
    }
    
    // Return data as JSON
    header('Content-Type: application/json');
    echo json_encode(['userType'=>$userType,'product'=>$categories]);
    
    // Close connections
    $stmt->close();
    $con->close();

    
    
        
    function generateRandomString($length = 6) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
    
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return 'CAT-'.$randomString;
    }


   
    
    
    


?>