<?php

    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST', 'OPTIONS');
    header("Access-Control-Allow-Credentials: true");
    header("Access-Control-Max-Age: 86400");
    header("Access-Control-Allow-Headers: X-Requested-With");
    // header("Access-Control-Allow-Headers", "Access-Control-Allow-Headers, Origin,Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers");


    include "./connify.php";
    // include "./clean.php";
     
    $product_id          = (mysqli_real_escape_string($con,$_POST['product_id']));
    $userHash      = (mysqli_real_escape_string($con,$_POST['userHash']));
    $cart         = (mysqli_real_escape_string($con,$_POST['cart'])); 
    $ID         = (mysqli_real_escape_string($con,$_POST['id'])); 
    
    
    // $stmt = $con -> prepare('SELECT  product_id FROM cart WHERE  id =?'); 
    // $stmt -> bind_param('i',$id); 
    // $stmt -> execute(); 
    // $stmt -> store_result(); 
    // $stmt -> bind_result($product_id);
    // $count  = $stmt->num_rows;
    // $stmt -> fetch();
    
     
    
    $stmt = $con -> prepare('SELECT   product,price,product_type,qty,tax,weightType FROM product WHERE  product_id =?'); 
    $stmt -> bind_param('i',$product_id); 
    $stmt -> execute(); 
    $stmt -> store_result(); 
    $stmt -> bind_result( $product,$price,$product_type,$qty,$tax,$weightType );
    $count  = $stmt->num_rows;
    $stmt -> fetch();
      
    if($count == 0){
        $msg = "Unable to Cart,, $product_id";
        $output = array('message'=>$msg);
        echo json_encode($output);
        exit(); 
    }else{
        
        
        if($cart > $qty){
            
            $msg = "Out of Bound";
            $output = array('message'=>$msg);
            echo json_encode($output);
            exit();
        }
        
        $status = 'pending';
        $stmt = $con -> prepare('SELECT price,qty FROM cart WHERE  product_id =? AND userHash =? AND status =? AND id =?'); 
        $stmt -> bind_param('ssss',$product_id,$userHash,$status,$ID); 
        $stmt -> execute(); 
        $stmt -> store_result(); 
        $stmt -> bind_result($price,$qty);
        $count  = $stmt->num_rows;
        $stmt -> fetch();
        
         
        
        if($count == 0){
            
            $status = 'pending';
            $date = date("Y-m-d");
            $timestamp = time();
            
             
            
            $taxedPrice = ($tax/100)*$price;
            $taxed = $taxedPrice+$price;
            
            $subtotal = $price * $cart;
            $total = $taxed * $cart;
            
            
            $status = 'pending'; 
            $stmt = $con -> prepare('INSERT INTO  cart (product,product_id,product_type,qty,price,tax,subtotal,total,timestamp,userHash,status) VALUES (?,?,?,?,?,?,?,?,?,?,?)');
            $stmt -> bind_param('sssssssssss',$product,$product_id,$product_type,$cart,$price,$taxed,$subtotal,$total, $timestamp,$userHash,$status);
            $stmt -> execute();
            
            $msg = "$product is now added to Cart";
            $output = array('message'=>$msg);
            echo json_encode($output);
            exit(); 
            
        }else{
            
            
            $newCart = $cart + 1; // Increment cart quantity
            $taxedPrice = ($tax / 100) * $price; // Calculate tax
            $taxed = $taxedPrice + $price; // Add tax to price
            
            $subtotal = $price * $newCart; // Calculate subtotal
            $total = $taxed * $newCart; // Calculate total
            
            $status = 'pending';  
            // Prepare the SQL statement
            $stmt = $con->prepare("UPDATE cart SET qty = ?, subtotal = ?, total = ? WHERE product_id = ? AND userHash = ? AND status = ? AND price = ? AND id =?");
            $stmt->bind_param("iddssssi", $newCart, $subtotal, $total, $product_id, $userHash, $status, $price,$ID);
            
            if ($stmt->execute()) {
                $msg = "Cart Updated.. $newCart"; // Include updated quantity in the message
                $output = array('message' => $msg, 'newCart' => $newCart);
                echo json_encode($output);
                exit();
            } else {
                $msg = "Unable to update Cart";
                $output = array('message' => $msg);
                echo json_encode($output);
                exit();
            }

            
            $stmt->close();

            
            
            
            
        }
         
        
        // $status = 'pending';
        // $date = date("Y-m-d");
        // $timestamp = time();
        // $stmt = $con -> prepare('INSERT INTO  cart (product,product_id,product_type,qty,price,tax,subtotal,timestamp,userHash) VALUES (?,?,?,?,?,?,?,?,?)');
        // $stmt -> bind_param('sssssssss',$product,$product_id,$product_type,$qty,$price,$tax,$subtotal,$timestamp,$userHash);
        // $stmt -> execute();
        
        $msg = "success";
        $output = array('message'=>$msg);
        echo json_encode($output);
        exit(); 
    }
    	
    
    
function generateRandomString($length = 6) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';

    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[random_int(0, $charactersLength - 1)];
    }
    return 'CAT-'.$randomString;
}


   
    
    
    


?>